# -*- coding: utf-8 -*-
from easygui import *
from pathlib import Path
from operator import itemgetter
import os
import sys
import re
import shutil
import datetime
import glob

filename = 'custom.csv'
dirname = './scenarios'
dir2name = '/custom/'
pathname = dirname+dir2name+filename
MAX_GEN = 9

def takeBackup():
    archive_files = glob.glob(dirname+dir2name+'[0-9]*.csv')
    file_list = []
    for file in archive_files:
        file_list.append([file,os.path.getctime(file)])

    if len(file_list) > MAX_GEN:
        sortedlist = sorted(file_list,key=itemgetter(1)) # sort by create time
        for i in range(MAX_GEN,len(file_list)): # erase older file
            os.remove(sortedlist[i][0])
            print("DELETED:"+sortedlist[i][0])
    #generate now time and make a copy as archive
    Nowtime = datetime.datetime.today().strftime("%Y%m%d-%H%M%S")
    shutil.copyfile(pathname,dirname+dir2name+Nowtime+'.'+filename)

def checkFlist(flist): # frequency must be [0-9,.]
    if re.match(r'^[0-9\,\.]+$',flist):
       return True
    else:
       return False

def showEntryBox(msg="",jname="",freqlist=""): #EasyGui date input wrapper
    title = "カスタム周波数作成"
    fieldNames = ["日本語名","周波数リスト"]
    fieldValues = [jname, freqlist]
    fieldValues = multenterbox(msg,title, fieldNames,fieldValues)
    return fieldValues

def appendRecord():
    while True:
        fieldValues = showEntryBox(msg="新たに追加します")
        if fieldValues == None:
            sys.exit()
        if (fieldValues[0] != "") and checkFlist(fieldValues[1]):
        	break
        fieldValues = showEntryBox(msg="入力にエラーがあります。周波数リストは数字、カンマ、コロンのみです。", jname=fieldValues[0], freqlist=fieldValues[1])

    # OK. write 
    takeBackup()
    ofh = open(pathname,'a',encoding='utf-8',errors='ignore')
    
    if fieldValues[1][-1] == ',':
        spacer = ''
    else:
        spacer = ','
    record = fieldValues[0] + "\t--\t"+fieldValues[1]+spacer+"\n"
    ofh.write(record)
    ofh.close()
    return

def rewriteFile(list):
    takeBackup()
    ofh = open(pathname,'w',encoding='utf-8')
    for data in list:
        fieldValues = data.split('|')
        if fieldValues[2][-1] == ',':
            spacer = ''
        else:
            spacer = ','
        record = fieldValues[1] + "\t--\t"+fieldValues[2]+spacer+"\n"
        ofh.write(record)
    ofh.close()
    return

def readFile(): #ファイルを読んでリストを作る
    options = []
    number = 0

    ifh = open(pathname,'r',encoding='utf-8',errors='ignore')
    records = ifh.readlines()
    for line in records:
        if line.find('\t'):
            list = line.split('\t')
            jname = list[0]
            freqs = list[2].strip()
            options.append(str(number).zfill(3)+"|"+jname+"|"+freqs)
            number+=1
    ifh.close()
    return options
    
def updateRecord():
    records = readFile()
    if not records:
        appendRecord()
        return
        
    selected = choicebox(msg='更新するリメディデータを選んでください',title='リメディ選択',choices=records )
        
    if selected == None:
        sys.exit()

    elements = selected.split("|")
    fieldValues = showEntryBox(msg="更新",jname=elements[1],freqlist=elements[2])
    if fieldValues == None:
        return

    while True:
        if checkFlist(fieldValues[1]):
            break
        fieldValues = showEntryBox(msg="入力にエラーがあります。周波数リストは数字、カンマ、コロンのみです", jname=fieldValues[0], freqlist=fieldValues[1])

    recordNumber = int(elements[0])
    records[recordNumber] = elements[0] + "|" + fieldValues[0] + "|" + fieldValues[1]
    rewriteFile(records)
    return

if __name__ == "__main__":

    if not os.path.isdir(dirname):
        print(dirname + 'が周囲に見つかりません。想定した環境と違うので終了します。')
        sys.exit()

    if not os.path.isdir(dirname+dir2name):
        os.mkdir(dirname+dir2name)

    if not os.path.isfile(pathname):
        Path(pathname).touch() # maybe first time, make skelton file.

# 無限ループ
    options = ['追加','更新']
    if ynbox(msg='新しいエントリーを追加しますか?',title='カスタムデータ編集',choices=options):
        appendRecord()

    while True:
        updateRecord()

